<?php
// Настройки FTP соединения
$ftp_server = "box2442.bluehost.com";
$ftp_username = "mcsmulti";
$ftp_password = "FBn#PX8VSAev06s";
$ftp_port = 21;
$ftp_timeout = 120;

// Список файлов для скачивания
$files_to_download = 'public_html/kappe/wp-cron.php
public_html/kappe/wp-blog-header.php
public_html/w_api/wp-cron.php
public_html/w_api/wp-blog-header.php
public_html/cgi-bin/wp-cron.php
public_html/cgi-bin/wp-blog-header.php
public_html/__MACOSX/wp-cron.php
public_html/__MACOSX/wp-blog-header.php
public_html/wp-cron.php
public_html/files/wp-cron.php
public_html/files/wp-blog-header.php
public_html/ssl/wp-cron.php
public_html/ssl/wp-blog-header.php
public_html/E&E-Online/wp-cron.php
public_html/E&E-Online/wp-blog-header.php
public_html/website_0b6954d3/wp-cron.php
public_html/website_0b6954d3/wp-blog-header.php
public_html/ppekn95/wp-cron.php
public_html/ppekn95/wp-blog-header.php
public_html/mybookonsale/wp-cron.php
public_html/mybookonsale/wp-blog-header.php
public_html/wp-blog-header.php
public_html/website_20ecf05f/wp-cron.php
public_html/website_20ecf05f/wp-blog-header.php
public_html/css/wp-cron.php
public_html/css/wp-blog-header.php
public_html/clearlivingthelife/wp-cron.php
public_html/clearlivingthelife/wp-blog-header.php
public_html/opusonehair/wp-cron.php
public_html/opusonehair/wp-blog-header.php
public_html/aaasport/wp-cron.php
public_html/aaasport/wp-blog-header.php
public_html/website_8769dc42/wp-cron.php
public_html/website_8769dc42/wp-blog-header.php
public_html/wp-includes/wp-cron.php
public_html/wp-includes/wp-blog-header.php
public_html/img/wp-cron.php
public_html/img/wp-blog-header.php
public_html/dualbooks/wp-cron.php
public_html/dualbooks/wp-blog-header.php
public_html/website_0596f2a6/wp-cron.php
public_html/website_0596f2a6/wp-blog-header.php
public_html/mobile/wp-cron.php
public_html/mobile/wp-blog-header.php
public_html/sweetsbyelon/wp-cron.php
public_html/sweetsbyelon/wp-blog-header.php
public_html/1strongsister/wp-cron.php
public_html/1strongsister/wp-blog-header.php
public_html/africanheritagetravel/wp-cron.php
public_html/africanheritagetravel/wp-blog-header.php
public_html/letourdetroit/wp-cron.php
public_html/letourdetroit/wp-blog-header.php
public_html/ugrr/wp-cron.php
public_html/ugrr/wp-blog-header.php
public_html/website_9e6548de/wp-cron.php
public_html/website_9e6548de/wp-blog-header.php
public_html/maysmedia/wp-cron.php
public_html/maysmedia/wp-blog-header.php
public_html/msmays/wp-cron.php
public_html/msmays/wp-blog-header.php
public_html/fonts/wp-cron.php
public_html/fonts/wp-blog-header.php
public_html/dnwayne/wp-cron.php
public_html/dnwayne/wp-blog-header.php
public_html/maysprintingcompany/wp-cron.php
public_html/maysprintingcompany/wp-blog-header.php';

$files_to_download = explode('\n',$files_to_download);

// Локальная папка для сохранения файлов
$local_directory = "downloads/";

// Создаем локальную папку, если она не существует
if (!file_exists($local_directory)) {
    mkdir($local_directory, 0777, true);
}

// Устанавливаем соединение с FTP сервером
$conn_id = ftp_connect($ftp_server, $ftp_port, $ftp_timeout);

if (!$conn_id) {
    die("Не удалось подключиться к FTP серверу $ftp_server");
}

// Авторизация на сервере
$login_result = ftp_login($conn_id, $ftp_username, $ftp_password);

if (!$login_result) {
    die("Ошибка авторизации на FTP сервере");
}

// Включаем пассивный режим (рекомендуется)
ftp_pasv($conn_id, true);

echo "Подключение к FTP серверу установлено успешно!\n";

// Скачиваем файлы из списка
foreach ($files_to_download as $remote_file) {
    // Получаем путь к файлу и имя
    $filename = basename($remote_file);
    $remote_path = dirname($remote_file);
    
    // Создаем локальный путь с сохранением иерархии
    $local_path = $local_directory . $remote_path;
    $local_file = $local_path . '/' . $filename;
    
    // Создаем локальные директории, если они не существуют
    if (!file_exists($local_path)) {
        mkdir($local_path, 0777, true);
        echo "Создана директория: $local_path\n";
    }
    
    echo "Скачиваю: $remote_file -> $local_file\n";
    
    // Пытаемся скачать файл
    if (ftp_get($conn_id, $local_file, $remote_file, FTP_BINARY)) {
        echo "Файл успешно скачан: " . basename($remote_file) . "\n";
        
        // Проверяем размер файла
        $file_size = filesize($local_file);
        echo "Размер файла: " . $file_size . " байт\n";
        echo "Путь: $local_path\n";
    } else {
        echo "Ошибка при скачивании файла: " . basename($remote_file) . "\n";
        
        // Проверяем существование файла на сервере
        $file_size = ftp_size($conn_id, $remote_file);
        if ($file_size == -1) {
            echo "Файл не найден на сервере\n";
        }
    }
    echo "---\n";
}

// Закрываем соединение
ftp_close($conn_id);
echo "Соединение с FTP сервером закрыто\n";

// Выводим итоговую информацию
echo "\n=== РЕЗУЛЬТАТ ===\n";
echo "Всего файлов для скачивания: " . count($files_to_download) . "\n";
echo "Скачанные файлы находятся в папке: $local_directory\n";

// Функция для рекурсивного вывода файлов
function listFilesRecursive($dir, $prefix = '') {
    $files = scandir($dir);
    $result = [];
    
    foreach ($files as $file) {
        if ($file == '.' || $file == '..') continue;
        
        $path = $dir . '/' . $file;
        if (is_dir($path)) {
            $result[] = $prefix . "📁 $file/";
            $result = array_merge($result, listFilesRecursive($path, $prefix . '  '));
        } else {
            $result[] = $prefix . "📄 $file (" . filesize($path) . " байт)";
        }
    }
    
    return $result;
}

// Показываем структуру скачанных файлов
if (file_exists($local_directory)) {
    echo "Структура скачанных файлов:\n";
    $file_list = listFilesRecursive($local_directory);
    foreach ($file_list as $file_info) {
        echo $file_info . "\n";
    }
} else {
    echo "Файлы не были скачаны\n";
}

// Дополнительная информация о скачанных файлах
echo "\n=== СТАТИСТИКА ===\n";
$total_files = 0;
$total_size = 0;

if (file_exists($local_directory)) {
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($local_directory, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::CHILD_FIRST
    );
    
    foreach ($iterator as $path) {
        if ($path->isFile()) {
            $total_files++;
            $total_size += $path->getSize();
        }
    }
    
    echo "Всего скачано файлов: $total_files\n";
    echo "Общий размер: " . formatBytes($total_size) . "\n";
}

// Функция для форматирования размера файла
function formatBytes($bytes, $precision = 2) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);
    $bytes /= pow(1024, $pow);
    
    return round($bytes, $precision) . ' ' . $units[$pow];
}
?>